/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: FileExplorerDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 23.04.07 16:19 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    cifX File explorer dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        23.04.2007  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file FileExplorerDlg.h
///   cifX File explorer dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include "afxcmn.h"
#include <vector>
#include "cifxuser.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// cifX File Explorer dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CFileExplorerDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CFileExplorerDlg)

public:
	CFileExplorerDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CFileExplorerDlg();

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);

// Dialog Data
	enum { IDD = IDD_FILELISTING_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
  CComboBox m_cChannelCtrl;
  CListCtrl m_cFileListCtrl;

  std::vector<CIFX_DIRECTORYENTRY>  m_cvDirectory;

public:
  virtual BOOL OnInitDialog();
  void    UpdateFileList();
  void    AddFile(CIFX_DIRECTORYENTRY* ptDirEntry);
  afx_msg void OnBnClickedBtnRefresh();
  afx_msg void OnBnClickedBtnUpload();
  afx_msg void OnBnClickedBtnDelete();
  afx_msg void OnCbnSelchangeCbChannelselection();
};
